package pilot;

import java.awt.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
import rg.thopt.*;


/**
 * Subclass of Thermoptim simulator main class
 * <p>
 * Sous-classe de la principale classe du simulateur Thermoptim
 * 
 * @author Renaud Gicquel
 */

public class ProjetThopt extends Projet
{
 	protected  String tab=new String("\t");
	protected  String ligne=new String("\n");

    Vector calculatedElements;
    Vector vTechno;
 //   String[]element;
	int npass;

	//{{DECLARE_CONTROLS
	//}}

	//{{DECLARE_MENUS
	//}}
	

	/**
	 * basic constructor
	 */
	public ProjetThopt()
	{
        super();
        npass=0;
        calculatedElements=new Vector();
        vTechno=new Vector();
    		//{{INIT_CONTROLS
		//}}
		//{{INIT_MENUS
		//}}
    }
	/**
	 * permet au tuteur de prendre la main entre deux recalculs
	 *<p>
	 * allows the tutor to take control between two recalculations
	 *<p>
	 * this method overrides one of Thermoptim's Projet class
	 */
	public void setControls(){
	    npass++;
//	    System.out.println("nombre de passes : "+npass);
	}
	
	
    public Vector getInternalClasses(){
        Vector vClasses=new Vector();
        try{
		    Class c=Class.forName("extThopt.MonCapteurSolaire");//recompose le nom complet de la classe "extThopt.nomClasse" et charge la classe
            vClasses.addElement(c);
        }
        catch(Exception e){// complter par un traitement dtaill des exceptions, 
                            //pour informer le crateur de l'archive de ses erreurs de conception
            e.printStackTrace();
        }
        return vClasses;
    }
	
	
	
	/**
	 * construit un vecteur avec l'historique de tous les recalculs
	 *<p>
	 * builds a vector with the history of all recalculations
	 *<p>
	 * this method overrides one of Thermoptim's Projet class
	 */
	public void notifyElementCalculated(String[]element){
	    String mess="type="+element[0]+tab+"nom="+element[1]+tab+"catgorie="+element[2];
//	    System.out.println(mess);
	    Object[]obj=new Object[2];
	    obj=new Object[2];
	    obj[0]=mess;
	    obj[1]=getProperties(element);
	    calculatedElements.addElement(obj);
	}
	
	public Vector getCalculatedElements(){
	    return calculatedElements;
	}
	public Vector getPilotTechnos(){
	    return vTechno;
	}

}