/*
Copyright Renaud GICQUEL 2005-2011  
renaud.gicquel@s4e2.com

Ce logiciel est un programme informatique servant  modliser des systmes nergtiques.   

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et respectant les principes de diffusion des logiciels libres. Vous pouvez utiliser, modifier et/ou redistribuer ce programme sous les conditions de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA  sur le site "http://www.cecill.info".  

En contrepartie de l'accessibilit au code source et des droits de copie, de modification et de redistribution accords par cette licence, il n'est offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons, seule une responsabilit restreinte pse sur l'auteur du programme,  le titulaire des droits patrimoniaux et les concdants successifs.  

A cet gard  l'attention de l'utilisateur est attire sur les risques associs au chargement,   l'utilisation,   la modification et/ou au dveloppement et  la reproduction du logiciel par l'utilisateur tant  donn sa spcificit de logiciel libre, qui peut le rendre complexe   manipuler et qui le rserve donc  des dveloppeurs et des professionnels avertis possdant  des  connaissances  informatiques approfondies.  Les utilisateurs sont donc invits  charger  et  tester  l'adquation  du logiciel  leurs besoins dans des conditions permettant d'assurer la scurit de leurs systmes et ou de leurs donnes et, plus gnralement,   l'utiliser et l'exploiter dans les mmes conditions de scurit.   

Le fait que vous puissiez accder  cet en-tte signifie que vous avez  pris connaissance de la licence CeCILL, et que vous en avez accept les termes. 

This software is a computer program whose purpose is to model energy systems.  

This software is governed by the CeCILL  license under French law and abiding by the rules of distribution of free software.  You can  use,  modify and/ or redistribute the software under the terms of the CeCILL license as circulated by CEA, CNRS and INRIA at the following URL "http://www.cecill.info".   

As a counterpart to the access to the source code and  rights to copy, modify and redistribute granted by the license, users are provided only with a limited warranty  and the software's author,  the holder of the economic rights,  and the successive licensors  have only  limited liability.   

In this respect, the user's attention is drawn to the risks associated with loading,  using,  modifying and/or developing or reproducing the software by the user in light of its specific status of free software, that may mean  that it is complicated to manipulate,  and  that  also therefore means  that it is reserved for developers  and  experienced professionals having in-depth computer knowledge. Users are therefore encouraged to load and test the software's suitability as regards their requirements in conditions enabling the security of their systems and/or  data to be ensured and,  more generally, to use and operate it in the  same conditions as regards security.   

The fact that you are presently reading this means that you have had knowledge of the CeCILL license and that you accept its terms.  
*/
package extThopt;

import java.util.*; 
import javax.swing.*;

public class MonCapteurSolaire extends ExtProcess 
{
    
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JTextField tau_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JTextField K_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel3 = new javax.swing.JLabel();
	javax.swing.JTextField P_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel4 = new javax.swing.JLabel();
	javax.swing.JTextField A_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel5 = new javax.swing.JLabel();
	javax.swing.JTextField Tex_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel6 = new javax.swing.JLabel();
	javax.swing.JTextField eff_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel7 = new javax.swing.JLabel();
	javax.swing.JTextField compRef = new javax.swing.JTextField();
    
    double tau, K, P, A, Tout;
    double Ti, Taval, Pamont, Paval;
    
    public MonCapteurSolaire (){
        super();
		JPanel1.setLayout(null);
		JPanel1.setBounds(0,0,400,300);
		JLabel1.setText("glass transmittivity");
		JPanel1.add(JLabel1);
		JLabel1.setBounds(0,0,164,24);
		JPanel1.add(tau_value);
		tau_value.setBounds(164,0,124,24);
		tau_value.setText("0.8");
		JLabel2.setText("thermal loss coefficient");
		JPanel1.add(JLabel2);
		JLabel2.setBounds(0,30,164,24);
		JPanel1.add(K_value);
		K_value.setBounds(164,30,124,24);
		K_value.setText("0.001");
		JLabel3.setText("solar flux (W/m2)");
		JPanel1.add(JLabel3);
		JLabel3.setBounds(0,60,164,24);
		JPanel1.add(P_value);
		P_value.setBounds(164,60,124,24);
		P_value.setText("1000");
		JLabel4.setText("collector area (m2)");
		JPanel1.add(JLabel4);
		JLabel4.setBounds(0,90,164,24);
		JPanel1.add(A_value);
		A_value.setBounds(164,90,124,24);
		A_value.setText("10");
		JLabel5.setText("outdoor temperature (C)");
		JPanel1.add(JLabel5);
		JLabel5.setBounds(0,120,164,24);
		JPanel1.add(Tex_value);
		Tex_value.setBounds(164,120,124,24);
		Tex_value.setText("10");
		JLabel6.setText("solar collector efficiency");
		JPanel1.add(JLabel6);
		JLabel6.setBounds(0,150,164,24);
		JPanel1.add(eff_value);
		eff_value.setBounds(164,150,124,24);
		eff_value.setText("0.8");
		JLabel7.setText("reference");
		JPanel1.add(JLabel7);
		JLabel7.setBounds(0,180,108,24);
		JPanel1.add(compRef);
		compRef.setBounds(108,180,192,24);
		type=getCompType();
   		thermoCouplerTypes=new String[0];//no thermocoupler connected
 }
    
    public String getCompType(){
        return "mon capteur";
    }
    public String getType(){
        return getCompType();
    }
	public String getClassDescription(){
	    return "flat plate solar collector (without thermocoupler)\n\nauthor : R. Gicquel  january 2003\n\nRef : archive SolarCollector.zip";
	}
    
    
	public void calculateProcess(){
        String[] args=new String[2];
        args[0]="process";//type of the element (see method getProperties(String[] args))
        args[1]=tfe.getCompName();//name of the process (see method getProperties(String[] args))
        Vector vProp=proj.getProperties(args);
        Double f=(Double)vProp.elementAt(3);
        double flow=f.doubleValue();
        String amont=(String)vProp.elementAt(1);//gets the upstream point name
        getPointProperties(amont);//direct parsing of point property vector
        Ti=Tpoint;
    //    Taval=Tpoint;
        P=Util.lit_d(P_value.getText());
        A=Util.lit_d(A_value.getText());
        tau=Util.lit_d(tau_value.getText());
        K=Util.lit_d(K_value.getText());
        Tout=Util.lit_d(Tex_value.getText())+273.15;
        
        double H=Hpoint;
        lecorps.CalcPropCorps(Tpoint+1, Ppoint, Xpoint);//this method recalculates the substance properties 
        getSubstProperties(nomCorps);
        double Cp=(Hsubst-H);
        
        double DT0=tau*P/K-Ti+Tout;
        double T=Ti+(DT0)*(1-Math.exp(-K/1000*A/flow/Cp));
        double DT=T-Tpoint;
        double Q=Cp*DT*flow;
        
        double hAval=Q/flow+Hpoint;
        Tpoint=lecorps.getT_from_hP(hAval,Ppoint);
        getSubstProperties(nomCorps);
        Xpoint=Xsubst;
        tfe.setupPointAval(getProperties());
        eff_value.setText(Util.aff_d(Q/P*1000/A, 4));
	    
	}
    
	public void readCompParameters(String ligne_data){
		tau=Util.lit_d(Util.extr_value(ligne_data, "tau_value"));
	    tau_value.setText(Util.aff_d(tau));
		K=Util.lit_d(Util.extr_value(ligne_data, "K_value"));
	    K_value.setText(Util.aff_d(K));
		P=Util.lit_d(Util.extr_value(ligne_data, "P_value"));
	    P_value.setText(Util.aff_d(P));
		A=Util.lit_d(Util.extr_value(ligne_data, "A_value"));
	    A_value.setText(Util.aff_d(A));
		Tout=Util.lit_d(Util.extr_value(ligne_data, "Tex_value"));
	    Tex_value.setText(Util.aff_d(Tout));
	    eff_value.setText(Util.extr_value(ligne_data, "eff_value"));
        String valeur=Util.extr_value(ligne_data, "compRef");
        if(valeur!=null)compRef.setText(valeur);
	}
	
    public String saveCompParameters(){
	    String h="tau_value="+tau_value.getText()+tab
	    +"K_value="+K_value.getText()+tab
	    +"P_value="+P_value.getText()+tab
	    +"A_value="+A_value.getText()+tab
	    +"Tex_value="+Tex_value.getText()+tab
	    +"eff_value="+eff_value.getText()+tab
	    +"compRef="+compRef.getText()+tab
	    ;
        return h;
    }
 

}