var Sections = function(template) {
	this.list = [];
	this.current = 0;

	this.node = document.createElement("div");
	this.menuNode = document.createElement("ul");
	this.viewNode = document.createElement("div");
	this.nextNode = document.createElement("img");
	this.previousNode = document.createElement("img");
	this.selectorNode = document.createElement("div");


	this.init(template);
};

Sections.prototype.init = function(template) {
	var self = this;
	this.node.className = "sections";
	this.node.appendChild(this.menuNode);
	this.node.appendChild(this.viewNode);
	this.node.appendChild(this.selectorNode);

	this.selectorNode.className = "selector";
	this.viewNode.className = "view";

	this.previousNode.src = "img/icons/previous_16.png";
	this.previousNode.onclick = function(e) { self.previous() };
	this.selectorNode.appendChild(this.previousNode);

	this.nextNode.src = "img/icons/next_16.png";
	this.nextNode.onclick = function(e) { self.next() };
	this.selectorNode.appendChild(this.nextNode);

	var end = document.createElement("div");
	end.className = "end";
	this.node.appendChild(end);

	this.extract(template);
	this.show(this.current);
};

Sections.prototype.push = function(item) {
	this.list.push(item);
	this.menuNode.appendChild(item.node);
};

Sections.prototype.extract = function(parent) {
	var sections = document.getChildsByTagName(parent, "section");
	for (var i = 0; i < sections.length; i++) {
		var section = sections[i];
		if (section.getAttribute("default") == "true") this.current = i;
		var h1 = document.getChildsByTagName(section, "h1");
		if (h1.length > 0) {
			var title = h1[0].innerText;
			var item = new SectionsItem(this, title, section, this.list.length);
			this.push(item);
		}
	}
}

Sections.prototype.previous = function() {
	this.showInc(-1);
	this.currentItem.scrollIntoView(false);
};

Sections.prototype.next = function() {
	this.showInc(+1);
	this.currentItem.scrollIntoView(false);
};

Sections.prototype.showItem = function(item) {
	if (this.currentItem) this.currentItem.setCurrent(false);
	while (this.viewNode.firstChild) this.viewNode.removeChild(this.viewNode.firstChild);
	this.currentItem = item;
	this.currentItem.setCurrent(true);
	this.viewNode.appendChild(item.target);
};

Sections.prototype.show = function(index) {
	this.current = index;
	this.previousNode.className = index > 0 ? "" : "disabled";
	this.nextNode.className = (index < this.list.length - 1) ? "" : "disabled";
	this.showItem(this.list[index]);
};

Sections.prototype.showInc = function(value) {
	var i = this.current + value;
	i = Math.min(i, this.list.length - 1)
	i = Math.max(i, 0);
	this.show(i);
};

var SectionsItem = function(parent, title, target, index) {
	this.parent = parent;
	this.title = title;
	this.target = target;
	this.index = index;
	this.node = document.createElement("li");
	this.init();
};

SectionsItem.prototype.init = function() {
	var self = this;

	this.node.appendChild(document.createTextNode(this.title));
	this.node.onclick = function(e) { self.onclick(e); };

	var end = document.createElement("div");
	end.className = "end";
	this.target.appendChild(end);
};

SectionsItem.prototype.onclick = function(e) {
	this.parent.show(this.index);
	this.scrollIntoView(false);
};

SectionsItem.prototype.setCurrent = function(value) {
	this.node.className = value ? "current" : "";
};

SectionsItem.prototype.scrollIntoView = function(alignWithTop) {
	this.node.scrollIntoView(alignWithTop);
};
