/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.xml.svg;

import com.ibm.xml.parser.ElementHandler;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TagHandler;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigInk;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigSpline;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.xml.DTDEntityResolver;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class SVGParser
implements ElementHandler,
TagHandler {
    public static SVGParser SINGLETON = new SVGParser();
    protected Diagram _diagram = null;
    protected int _nestedGroups = 0;
    protected Hashtable _figRegistry;
    protected Hashtable _ownerRegistry;

    /*
     * Unable to fully structure code
     */
    protected Fig findFig(String var1_1) {
        block2: {
            block1: {
                var2_2 = null;
                if (var1_1.indexOf(".") != -1) break block1;
                var2_2 = (Fig)this._figRegistry.get(var1_1);
                break block2;
            }
            var3_3 = new StringTokenizer(var1_1, ".");
            var4_4 = var3_3.nextToken();
            var2_2 = (Fig)this._figRegistry.get(var4_4);
            if (!(var2_2 instanceof FigEdge)) ** GOTO lbl15
            return ((FigEdge)var2_2).getFig();
lbl-1000:
            // 1 sources

            {
                if (!(var2_2 instanceof FigGroup)) continue;
                var5_5 = var3_3.nextToken();
                var6_6 = Integer.parseInt(var5_5);
                var2_2 = (Fig)((FigGroup)var2_2).getFigs().elementAt(var6_6);
lbl15:
                // 3 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        return var2_2;
    }

    protected Object findOwner(String string) {
        Object v = this._ownerRegistry.get(string);
        return v;
    }

    protected GraphModel getGraphModelFor(String string) {
        return new DefaultGraphModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TXElement handleElement(TXElement tXElement) {
        try {
            String string = tXElement.getName();
            if (string.equals("svg")) return tXElement;
            if (string.equals("g")) {
                this._diagram.add(this.handleGroup(tXElement));
                return tXElement;
            }
            if (this._nestedGroups == 0) {
                if (string.equals("path")) {
                    this._diagram.add(this.handlePath(tXElement));
                    return tXElement;
                } else if (string.equals("ellipse")) {
                    this._diagram.add(this.handleEllipse(tXElement));
                    return tXElement;
                } else if (string.equals("rect")) {
                    this._diagram.add(this.handleRect(tXElement));
                    return tXElement;
                } else if (string.equals("text")) {
                    this._diagram.add(this.handleText(tXElement));
                    return tXElement;
                } else if (string.equals("line")) {
                    this._diagram.add(this.handleLine(tXElement));
                    return tXElement;
                } else {
                    System.out.println("unknown top-level tag: " + string);
                }
                return tXElement;
            }
            if (this._nestedGroups <= 0) return tXElement;
        }
        catch (Exception exception) {
            System.out.println("Exception in SVGParser handleElement");
            exception.printStackTrace();
        }
        return tXElement;
    }

    protected FigCircle handleEllipse(TXElement tXElement) {
        FigCircle figCircle = new FigCircle(0, 0, 50, 50);
        this.setAttrs(figCircle, tXElement);
        String string = tXElement.getAttribute("cx");
        String string2 = tXElement.getAttribute("cy");
        String string3 = tXElement.getAttribute("rx");
        String string4 = tXElement.getAttribute("ry");
        int n = string == null || string.equals("") ? 0 : Integer.parseInt(string);
        int n2 = string2 == null || string2.equals("") ? 0 : Integer.parseInt(string2);
        int n3 = string3 == null || string3.equals("") ? 10 : Integer.parseInt(string3);
        int n4 = string4 == null || string4.equals("") ? 10 : Integer.parseInt(string4);
        figCircle.setX(n - n3);
        figCircle.setY(n2 - n4);
        figCircle.setWidth(n3 * 2);
        figCircle.setHeight(n4 * 2);
        return figCircle;
    }

    public void handleEndTag(TXElement tXElement, boolean bl) {
        String string = tXElement.getName();
        if ("g".equals(string)) {
            --this._nestedGroups;
        }
    }

    protected Fig handleGroup(TXElement tXElement) {
        Fig fig = null;
        String string = tXElement.getAttribute("class");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;[] ");
        String string2 = stringTokenizer.nextToken();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
        }
        try {
            Class<?> clazz = Class.forName(string2);
            fig = (Fig)clazz.newInstance();
            if (string3 != null && !string3.equals("")) {
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                int n3 = Integer.parseInt(string5);
                int n4 = Integer.parseInt(string6);
                fig.setBounds(n, n2, n3, n4);
            }
            if (fig instanceof FigNode) {
                NodeList nodeList;
                FigNode figNode = (FigNode)fig;
                if (tXElement.hasChildNodes() && (nodeList = tXElement.getElementsByTagName("foreignObject")).getLength() == 1) {
                    TXElement tXElement2 = (TXElement)nodeList.item(0);
                    String string7 = tXElement2.getText();
                    figNode.setPrivateData(string7);
                }
            }
            if (fig instanceof FigEdge) {
                NodeList nodeList;
                FigEdge figEdge = (FigEdge)fig;
                if (tXElement.hasChildNodes() && (nodeList = tXElement.getElementsByTagName("foreignObject")).getLength() == 1) {
                    TXElement tXElement3 = (TXElement)nodeList.item(0);
                    String string8 = tXElement3.getText();
                    figEdge.setPrivateData(string8);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in handleGroup");
            exception.printStackTrace();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.out.println("No constructor() in class " + string2);
            noSuchMethodError.printStackTrace();
        }
        return fig;
    }

    protected FigLine handleLine(TXElement tXElement) {
        FigLine figLine = new FigLine(0, 0, 100, 100);
        this.setAttrs(figLine, tXElement);
        String string = tXElement.getAttribute("x1");
        String string2 = tXElement.getAttribute("y1");
        String string3 = tXElement.getAttribute("x2");
        String string4 = tXElement.getAttribute("y2");
        int n = string == null || string.equals("") ? 0 : Integer.parseInt(string);
        int n2 = string2 == null || string2.equals("") ? 0 : Integer.parseInt(string2);
        int n3 = string3 == null || string3.equals("") ? n : Integer.parseInt(string3);
        int n4 = string4 == null || string4.equals("") ? n2 : Integer.parseInt(string4);
        figLine.setX1(n);
        figLine.setY1(n2);
        figLine.setX2(n3);
        figLine.setY2(n4);
        return figLine;
    }

    protected FigPoly handlePath(TXElement tXElement) {
        String string = tXElement.getAttribute("class");
        FigPoly figPoly = null;
        if (string.equals("org.tigris.gef.presentation.FigPoly")) {
            figPoly = new FigPoly();
        } else if (string.equals("org.tigris.gef.presentation.FigSpline")) {
            figPoly = new FigSpline();
        } else if (string.equals("org.tigris.gef.presentation.FigInk")) {
            figPoly = new FigInk();
        }
        if (figPoly != null) {
            this.setAttrs(figPoly, tXElement);
            String string2 = tXElement.getAttribute("d");
            int n = -1;
            int n2 = -1;
            try {
                StringReader stringReader = new StringReader(string2);
                StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
                int n3 = streamTokenizer.nextToken();
                while (n3 != -1) {
                    if (n3 == -2) {
                        if (n == -1) {
                            n = (int)streamTokenizer.nval;
                        } else {
                            n2 = (int)streamTokenizer.nval;
                        }
                        if (n != -1 && n2 != -1) {
                            figPoly.addPoint(n, n2);
                            n = -1;
                            n2 = -1;
                        }
                    }
                    n3 = streamTokenizer.nextToken();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return figPoly;
    }

    protected FigRect handleRect(TXElement tXElement) {
        FigRect figRect;
        String string = tXElement.getAttribute("rx");
        if (string == null || string.equals("")) {
            figRect = new FigRect(0, 0, 80, 80);
        } else {
            figRect = new FigRRect(0, 0, 80, 80);
            int n = Integer.parseInt(string);
            ((FigRRect)figRect).setCornerRadius(n);
        }
        this.setAttrs(figRect, tXElement);
        return figRect;
    }

    public void handleStartTag(TXElement tXElement, boolean bl) {
        String string = tXElement.getName();
        if ("g".equals(string)) {
            ++this._nestedGroups;
        } else if (string.equals("svg")) {
            this.handleSVG(tXElement);
        }
    }

    protected void handleSVG(TXElement tXElement) {
        String string = tXElement.getAttribute("gef:name");
        String string2 = tXElement.getAttribute("class");
        try {
            if (string2 != null && !string2.equals("")) {
                this.initDiagram(string2);
            }
            if (string != null && !string.equals("")) {
                this._diagram.setName(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in handleSVG");
        }
    }

    protected FigText handleText(TXElement tXElement) {
        FigText figText = new FigText(100, 100, 90, 45);
        this.setAttrs(figText, tXElement);
        String string = tXElement.getText();
        figText.setText(string);
        String string2 = tXElement.getAttribute("style");
        if (string2 != null) {
            String string3;
            String string4 = this.parseStyle("font", string2);
            if (string4 != null) {
                figText.setFontFamily(string4);
            }
            if ((string3 = this.parseStyle("font-size", string2)) != null) {
                int n = Integer.parseInt(string3);
                figText.setFontSize(n);
            }
        }
        return figText;
    }

    protected void initDiagram(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf("|");
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            this._diagram = (Diagram)clazz.newInstance();
            if (string3 != null && !string3.equals("")) {
                this._diagram.initialize(this.findOwner(string3));
            }
        }
        catch (Exception exception) {
            System.out.println("could not set diagram type to " + string2);
            exception.printStackTrace();
        }
    }

    protected Color parseColor(String string, Color color) {
        try {
            int n = string.indexOf("rgb", 0);
            if (n != -1) {
                n = string.indexOf("(", n);
                int n2 = string.indexOf(",", n);
                if (n != -1) {
                    int n3 = Integer.parseInt(string.substring(++n, n2).trim());
                    n = n2 + 1;
                    n2 = string.indexOf(",", n);
                    int n4 = Integer.parseInt(string.substring(n, n2).trim());
                    n = n2 + 1;
                    n2 = string.indexOf(")", n);
                    int n5 = Integer.parseInt(string.substring(n, n2).trim());
                    return new Color(n3, n4, n5);
                }
                return color;
            }
        }
        catch (Exception exception) {
            System.out.println("invalid rgb() sequence: " + string);
            return color;
        }
        if (string.equalsIgnoreCase("none")) {
            return null;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            System.out.println("invalid color code string: " + string);
            return color;
        }
    }

    protected String parseStyle(String string, String string2) {
        int n = string2.indexOf(string = string + ":", 0);
        if (n != -1) {
            int n2 = string2.indexOf(";", n);
            if (n2 != -1) {
                return string2.substring(n + string.length(), n2).trim();
            }
            return string2.substring(n + string.length(), string2.length() - 1).trim();
        }
        return null;
    }

    public synchronized Diagram readDiagram(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            String string = uRL.getFile();
            System.out.println("=======================================");
            System.out.println("== READING DIAGRAM: " + uRL);
            Parser parser = new Parser(string);
            parser.addElementHandler((ElementHandler)this);
            parser.setTagHandler((TagHandler)this);
            parser.getEntityHandler().setEntityResolver((EntityResolver)DTDEntityResolver.SINGLETON);
            this.initDiagram("org.tigris.gef.base.Diagram");
            this._figRegistry = new Hashtable();
            parser.readStream(inputStream);
            inputStream.close();
            return this._diagram;
        }
        catch (Exception exception) {
            System.out.println("Exception in readDiagram");
            exception.printStackTrace();
            return null;
        }
    }

    protected void setAttrs(Fig fig, TXElement tXElement) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = tXElement.getAttribute("name");
        if (string5 != null && !string5.equals("")) {
            this._figRegistry.put(string5, fig);
        }
        if ((string4 = tXElement.getAttribute("x")) != null && !string4.equals("")) {
            string3 = tXElement.getAttribute("y");
            string2 = tXElement.getAttribute("width");
            string = tXElement.getAttribute("height");
            int n = Integer.parseInt(string4);
            int n2 = string3 == null || string3.equals("") ? 0 : Integer.parseInt(string3);
            int n3 = string2 == null || string2.equals("") ? 20 : Integer.parseInt(string2);
            int n4 = string == null || string.equals("") ? 20 : Integer.parseInt(string);
            fig.setBounds(n, n2, n3, n4);
        }
        if ((string3 = tXElement.getAttribute("style")) != null) {
            String string6;
            String string7;
            string2 = this.parseStyle("stroke-width", string3);
            if (string2 != null && !string2.equals("")) {
                fig.setLineWidth(Integer.parseInt(string2));
            }
            if ((string = this.parseStyle("stroke", string3)) != null && !string.equals("")) {
                fig.setLineColor(this.parseColor(string, Color.blue));
            }
            if ((string7 = this.parseStyle("fill", string3)) != null && !string7.equals("")) {
                fig.setFillColor(this.parseColor(string7, Color.blue));
            }
            if ((string6 = this.parseStyle("stroke-dash-array", string3)) != null && !string6.equals("") && !string6.equals("1")) {
                fig.setDashed(true);
            }
        }
        try {
            string2 = tXElement.getAttribute("gef:href");
            if (string2 != null && !string2.equals("")) {
                fig.setOwner(this.findOwner(string2));
            }
        }
        catch (Exception exception) {
            System.out.println("could not set owner");
        }
    }

    public void setOwnerRegistery(Hashtable hashtable) {
        this._ownerRegistry = hashtable;
    }

    protected SVGParser() {
    }
}

