/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Progress
extends Frame
implements ActionListener {
    private static final int BAR_WIDTH = 250;
    private static final int BAR_HEIGHT = 20;
    private static final int BORDER = 10;
    private int _total;
    private int _current = 0;
    private boolean _canceled = false;
    private Canvas _barCanvas;
    private Label _header;
    private TextField _message;
    private Button _cancelButton;

    public void advance() {
        ++this._current;
        this.paintBar();
    }

    public int current() {
        return this._current;
    }

    public int total() {
        return this._total;
    }

    public int percentComplete() {
        return this._current * 100 / this._total;
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void setMessage(String string) {
        this._message.setText(string);
        this.update(this.getGraphics());
    }

    protected int pixelsComplete() {
        return this._current * 250 / this._total;
    }

    protected void build() {
        this.add(this._header);
        this._header.setAlignment(1);
        this._header.setFont(new Font("Times Roman", 1, 18));
        this.setLayout(new GridLayout(4, 1, 10, 0));
        this._barCanvas = new Canvas();
        this._barCanvas.setSize(270, 40);
        this.add(this._barCanvas);
        this._message = new TextField("Working...");
        this._message.setEditable(false);
        this.add(this._message);
        Panel panel = new Panel();
        this._cancelButton = new Button("Cancel");
        this._cancelButton.addActionListener(this);
        panel.add(this._cancelButton);
        this.add(panel);
        this.pack();
    }

    public void paint(Graphics graphics) {
        this.paintBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancelButton) {
            this._canceled = true;
            this._cancelButton.setBackground(Color.darkGray);
        }
    }

    protected void paintBar() {
        Graphics graphics = this._barCanvas.getGraphics();
        Image image = this.createImage(270, 40);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(((Component)this).getBackground());
        graphics2.fillRect(0, 0, 270, 40);
        graphics2.setColor(Color.gray);
        graphics2.fillRect(10, 10, this.pixelsComplete(), 20);
        graphics2.setColor(Color.darkGray);
        graphics2.draw3DRect(11, 11, this.pixelsComplete() - 1, 18, true);
        graphics2.setColor(Color.black);
        graphics2.drawRect(10, 10, 250, 20);
        String string = Integer.toString(this.percentComplete()) + "% Complete";
        graphics.setFont(new Font("Times Roman", 0, 12));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() / 2;
        int n2 = fontMetrics.stringWidth(string) / 2;
        graphics2.drawString(string, 135 - n2, 20 + n);
        graphics.drawImage(image, 0, 0, null);
        graphics2.dispose();
        image.flush();
    }

    public static void main(String[] stringArray) {
        Progress progress = new Progress("Test", 100);
        progress.show();
        int n = 0;
        while (n < 100) {
            System.out.println(n);
            if (progress.canceled()) break;
            progress.advance();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        ((Component)progress).setVisible(false);
        progress.dispose();
    }

    public Progress(String string, int n) {
        this._header = new Label(string);
        this._total = n;
        if (this._total < 1) {
            this._total = 1;
        }
        this.build();
        this.setTitle("Progress");
    }
}

