/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigris.gef.properties.ui.ColorPickerGrid;

public class ColorEditor
extends JPanel
implements PropertyEditor {
    public Color _color = Color.white;
    private Vector listeners;

    public void setValue(Object object) {
        if (!(object instanceof Color)) {
            return;
        }
        this._color = (Color)object;
        this.repaint();
        this.firePropertyChange();
    }

    public Object getValue() {
        return this._color;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
        graphics.setColor((Color)this.getValue());
        graphics.fill3DRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, true);
    }

    public void paint(Graphics graphics) {
        this.paintValue(graphics, this.getBounds());
    }

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + this.getAsText() + ")";
    }

    public String getAsText() {
        return "" + this._color.getRed() + ", " + this._color.getBlue() + ", " + this._color.getGreen();
    }

    public void setAsText(String string) {
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        ColorPickerGrid colorPickerGrid = new ColorPickerGrid(Color.white);
        colorPickerGrid.setPEColor(this);
        return colorPickerGrid;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Frame getFrame() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public void firePropertyChange() {
        Vector vector;
        ColorEditor colorEditor = this;
        synchronized (colorEditor) {
            if (this.listeners == null) {
                Object var4_2 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public ColorEditor() {
        this.setLayout(null);
        this.setSize(this.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.setForeground(Color.lightGray);
    }
}

