/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;

public class FigEdgeRectiline
extends FigEdge {
    protected boolean _initiallyLaidOut = false;

    protected Fig makeEdgeFig() {
        FigPoly figPoly = new FigPoly(Color.black);
        figPoly.setRectilinear(true);
        figPoly.setFixedHandles(1);
        figPoly.setFilled(false);
        return figPoly;
    }

    public void computeRoute() {
        Point point;
        Point point2;
        if (!this._initiallyLaidOut) {
            this.layoutEdge();
            this._initiallyLaidOut = true;
        }
        FigPoly figPoly = (FigPoly)this._fig;
        if (this._useNearest) {
            point2 = this._sourcePortFig.connectionPoint(figPoly.getPoints(1));
            point = this._destPortFig.connectionPoint(figPoly.getPoints(figPoly.getNumPoints() - 2));
        } else {
            point2 = this._sourcePortFig.center();
            point = this._destPortFig.center();
        }
        figPoly.setEndPoints(point2, point);
        this.calcBounds();
    }

    protected void layoutEdge() {
        int n = 0;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        Point point = this._sourcePortFig.center();
        Point point2 = this._destPortFig.center();
        if (this._useNearest) {
            point = this._sourcePortFig.connectionPoint(point2);
            point2 = this._destPortFig.connectionPoint(point);
            point = this._sourcePortFig.connectionPoint(point2);
            point2 = this._destPortFig.connectionPoint(point);
        }
        Rectangle rectangle = this._sourceFigNode.routingRect();
        Rectangle rectangle2 = this._destFigNode.routingRect();
        Object object = this._sourcePortFig.getOwner();
        Object object2 = this._destPortFig.getOwner();
        int n2 = this._sourceFigNode.getPortSector(this._sourcePortFig);
        int n3 = this._destFigNode.getPortSector(this._destPortFig);
        Point point3 = this.routingRectPoint(point, rectangle, n2);
        Point point4 = this.routingRectPoint(point2, rectangle2, n3);
        if (n2 == 1 || n2 == -1) {
            nArray[n] = point.x;
            nArray2[n++] = point.y;
        }
        nArray[n] = point.x;
        nArray2[n++] = point.y;
        nArray[n] = point3.x;
        nArray2[n++] = point3.y;
        n += this.tryRoute(point4.x, point4.y, n, nArray, nArray2, rectangle, rectangle2, n2, n3);
        nArray[n] = point4.x;
        nArray2[n++] = point4.y;
        nArray[n] = point2.x;
        nArray2[n++] = point2.y;
        Polygon polygon = new Polygon(nArray, nArray2, n);
        ((FigPoly)this._fig).setPolygon(polygon);
    }

    protected Point routingRectPoint(Point point, Rectangle rectangle, int n) {
        switch (n) {
            case -1: {
                return new Point(point.x, rectangle.y);
            }
            case 2: {
                return new Point(rectangle.x, point.y);
            }
            case 1: {
                return new Point(point.x, rectangle.y + rectangle.height);
            }
            case -2: {
                return new Point(rectangle.x + rectangle.width, point.y);
            }
        }
        System.out.println("error, undefined sector!");
        return point;
    }

    protected int tryRoute(int n, int n2, int n3, int[] nArray, int[] nArray2, Rectangle rectangle, Rectangle rectangle2, int n4, int n5) {
        if (n3 > 12) {
            return 0;
        }
        int n6 = nArray[n3 - 1];
        int n7 = nArray2[n3 - 1];
        if ((n6 == n || n7 == n2) && this.segOK(n6, n7, n, n2, rectangle, rectangle2)) {
            nArray[n3] = n;
            nArray2[n3++] = n2;
            nArray[n3] = n;
            nArray2[n3++] = n2;
            return 1;
        }
        if (this.segOK(n6, n7, n6, n2, rectangle, rectangle2) && this.segOK(n6, n2, n, n2, rectangle, rectangle2)) {
            nArray[n3] = n6;
            nArray2[n3++] = n2;
            nArray[n3] = n;
            nArray2[n3++] = n2;
            return 2;
        }
        if (this.segOK(n6, n7, n, n7, rectangle, rectangle2) && this.segOK(n, n7, n, n2, rectangle, rectangle2)) {
            nArray[n3] = n;
            nArray2[n3++] = n7;
            nArray[n3] = n;
            nArray2[n3++] = n2;
            return 2;
        }
        Point point = this.findAvoidPt(n6, n7, n, n2, rectangle, rectangle2);
        if ((n4 == 1 || n4 == -1 || n7 == point.y) && n6 != point.x) {
            nArray[n3] = point.x;
            nArray2[n3++] = n7;
            return this.tryRoute(n, n2, n3, nArray, nArray2, rectangle, rectangle2, n4, n5) + 1;
        }
        if ((n4 == 2 || n4 == -2 || n6 == point.x) && n7 != point.y) {
            nArray[n3] = n6;
            nArray2[n3++] = point.y;
            return this.tryRoute(n, n2, n3, nArray, nArray2, rectangle, rectangle2, n4, n5) + 1;
        }
        return 0;
    }

    protected Point findAvoidPt(int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point(n, n2);
        point.x = rectangle.x + rectangle.width < rectangle2.x ? rectangle2.x : (rectangle2.x + rectangle2.width < rectangle.x ? rectangle.x : Math.min(rectangle.x, rectangle2.x));
        point.y = rectangle.y + rectangle.height < rectangle2.y ? rectangle2.y : (rectangle2.y + rectangle2.height < rectangle.y ? rectangle.y : Math.min(rectangle.y, rectangle2.y));
        return point;
    }

    protected boolean segOK(int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        int n9 = rectangle.x + rectangle.width;
        int n10 = rectangle.y + rectangle.height;
        if (n == n3 && n > rectangle.x && n < n9 && (n7 < rectangle.y && n8 > rectangle.y || n7 < n10 && n8 > n10)) {
            return false;
        }
        if (n2 == n4 && n2 > rectangle.y && n2 < n10 && (n5 < rectangle.x && n6 > rectangle.x || n5 < n9 && n6 > n9)) {
            return false;
        }
        n9 = rectangle2.x + rectangle2.width;
        n10 = rectangle2.y + rectangle2.height;
        if (n == n3 && n > rectangle2.x && n < n9 && (n7 < rectangle2.y && n8 > rectangle2.y || n7 < n10 && n8 > n10)) {
            return false;
        }
        return n2 != n4 || n2 <= rectangle2.y || n2 >= n10 || (n5 >= rectangle2.x || n6 <= rectangle2.x) && (n5 >= n9 || n6 <= n9);
    }
}

