/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import org.tigris.gef.presentation.Fig;

public abstract class ArrowHead
implements Serializable {
    protected int arrow_width = 7;
    protected int arrow_height = 12;
    protected Color arrowLineColor = Color.black;
    protected Color arrowFillColor = Color.black;

    public Color getLineColor() {
        return this.arrowLineColor;
    }

    public void setLineColor(Color color) {
        this.arrowLineColor = color;
    }

    public Color getFillColor() {
        return this.arrowFillColor;
    }

    public void setFillColor(Color color) {
        this.arrowFillColor = color;
    }

    public abstract void paint(Graphics var1, Point var2, Point var3);

    public void paintAtHead(Graphics graphics, Fig fig) {
        this.paint(graphics, fig.pointAlongPerimeter(5), fig.pointAlongPerimeter(0));
    }

    public void paintAtTail(Graphics graphics, Fig fig) {
        int n = fig.getPerimeterLength();
        this.paint(graphics, fig.pointAlongPerimeter(n - 6), fig.pointAlongPerimeter(n - 1));
    }

    public int getLineLength(Point point, Point point2) {
        int n = (point2.x - point.x) * (point2.x - point.x);
        int n2 = (point2.y - point.y) * (point2.y - point.y);
        return (int)Math.sqrt(n + n2);
    }

    public Point pointAlongLine(Point point, Point point2, int n) {
        int n2 = this.getLineLength(point, point2);
        int n3 = n;
        if (n2 == 0) {
            return point;
        }
        return new Point(point.x + (point2.x - point.x) * n3 / n2, point.y + (point2.y - point.y) * n3 / n2);
    }

    public double dist(int n, int n2, int n3, int n4) {
        double d = n - n3;
        double d2 = n2 - n4;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double dist(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public ArrowHead() {
    }

    public ArrowHead(Color color, Color color2) {
        this.setLineColor(color);
        this.setFillColor(color2);
    }
}

