/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public abstract class NetEdge
extends NetPrimitive
implements GraphEdgeHooks,
Serializable {
    protected NetPort _sourcePort;
    protected NetPort _destPort;
    protected Vector _ports;

    public void setSourcePort(NetPort netPort) {
        this._sourcePort = netPort;
    }

    public NetPort getSourcePort() {
        return this._sourcePort;
    }

    public void setDestPort(NetPort netPort) {
        this._destPort = netPort;
    }

    public NetPort getDestPort() {
        return this._destPort;
    }

    public NetPort otherEnd(NetPort netPort) {
        NetPort netPort2 = this.getSourcePort();
        if (netPort2 == netPort) {
            return this.getDestPort();
        }
        return netPort2;
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector vector) {
        this._ports = vector;
    }

    public boolean connect(GraphModel graphModel, Object object, Object object2) {
        NetPort netPort = (NetPort)object;
        NetPort netPort2 = (NetPort)object2;
        if (!netPort.canConnectTo(graphModel, object2)) {
            return false;
        }
        if (!netPort2.canConnectTo(graphModel, object)) {
            return false;
        }
        this.setSourcePort(netPort);
        this.setDestPort(netPort2);
        netPort.addEdge(this);
        netPort2.addEdge(this);
        netPort.postConnect(graphModel, object2);
        netPort2.postConnect(graphModel, object);
        return true;
    }

    public void dispose() {
        if (this.getSourcePort() != null && this.getDestPort() != null) {
            this._sourcePort.removeEdge(this);
            this._destPort.removeEdge(this);
            this._sourcePort.postDisconnect(null, this.getDestPort());
            this._destPort.postDisconnect(null, this.getSourcePort());
            this.firePropertyChange("disposed", false, true);
        }
    }

    public FigEdge presentationFor(Layer layer) {
        FigEdge figEdge;
        if (layer != null && (figEdge = (FigEdge)layer.presentationFor(this)) != null) {
            return figEdge;
        }
        NetNode netNode = this._sourcePort.getParentNode();
        NetNode netNode2 = this._destPort.getParentNode();
        FigNode figNode = netNode.presentationFor(layer);
        FigNode figNode2 = netNode2.presentationFor(layer);
        Fig fig = figNode.getPortFig(this._sourcePort);
        Fig fig2 = figNode2.getPortFig(this._destPort);
        figEdge = this.makePresentation(layer);
        figEdge.setSourcePortFig(fig);
        figEdge.setDestPortFig(fig2);
        figEdge.setSourceFigNode(figNode);
        figEdge.setDestFigNode(figNode2);
        figEdge.setOwner(this);
        return figEdge;
    }

    public abstract FigEdge makePresentation(Layer var1);
}

