/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import org.tigris.gef.base.CmdAdjustGrid;
import org.tigris.gef.base.CmdAdjustGuide;
import org.tigris.gef.base.CmdAdjustPageBreaks;
import org.tigris.gef.base.CmdAlign;
import org.tigris.gef.base.CmdCopy;
import org.tigris.gef.base.CmdDelete;
import org.tigris.gef.base.CmdDistribute;
import org.tigris.gef.base.CmdExit;
import org.tigris.gef.base.CmdGroup;
import org.tigris.gef.base.CmdNudge;
import org.tigris.gef.base.CmdOpen;
import org.tigris.gef.base.CmdOpenPGML;
import org.tigris.gef.base.CmdOpenSVG;
import org.tigris.gef.base.CmdOpenWindow;
import org.tigris.gef.base.CmdPaste;
import org.tigris.gef.base.CmdPrint;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.CmdSave;
import org.tigris.gef.base.CmdSavePGML;
import org.tigris.gef.base.CmdSaveSVG;
import org.tigris.gef.base.CmdSelectAll;
import org.tigris.gef.base.CmdSelectInvert;
import org.tigris.gef.base.CmdSelectNext;
import org.tigris.gef.base.CmdShowProperties;
import org.tigris.gef.base.CmdSpawn;
import org.tigris.gef.base.CmdUngroup;
import org.tigris.gef.base.CmdUseReshape;
import org.tigris.gef.base.CmdUseResize;
import org.tigris.gef.base.CmdUseRotate;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.JGraph;
import org.tigris.gef.ui.IStatusBar;
import org.tigris.gef.ui.PaletteFig;
import org.tigris.gef.ui.ToolBar;

public class JGraphFrame
extends JFrame
implements IStatusBar,
Cloneable,
ModeChangeListener {
    protected ToolBar _toolbar = new PaletteFig();
    protected JGraph _graph;
    protected JLabel _statusbar = new JLabel(" ");
    protected JPanel _mainPanel = new JPanel(new BorderLayout());
    protected JPanel _graphPanel = new JPanel(new BorderLayout());
    protected JMenuBar _menubar = new JMenuBar();

    public Object clone() {
        return null;
    }

    public JGraph getGraph() {
        return this._graph;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._graph.getEditor().getGraphEdgeRenderer();
    }

    public GraphModel getGraphModel() {
        return this._graph.getGraphModel();
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._graph.getEditor().getGraphNodeRenderer();
    }

    public JMenuBar getJMenuBar() {
        return this._menubar;
    }

    public ToolBar getToolBar() {
        return this._toolbar;
    }

    public void modeChange(ModeChangeEvent modeChangeEvent) {
        if (!Globals.getSticky() && Globals.mode() instanceof ModeSelect) {
            this._toolbar.unpressAllButtons();
        }
    }

    public void setGraph(JGraph jGraph) {
        this._graph = jGraph;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this._graph.getEditor().setGraphEdgeRenderer(graphEdgeRenderer);
    }

    public void setGraphModel(GraphModel graphModel) {
        this._graph.setGraphModel(graphModel);
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this._graph.getEditor().setGraphNodeRenderer(graphNodeRenderer);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this._menubar = jMenuBar;
        this.getContentPane().add((Component)this._menubar, "North");
    }

    public void setToolBar(ToolBar toolBar) {
        this._toolbar = toolBar;
        this._mainPanel.add((Component)this._toolbar, "North");
    }

    protected void setUpMenus() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this._menubar.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new CmdOpen());
        JMenuItem jMenuItem2 = jMenu.add(new CmdOpenPGML());
        JMenuItem jMenuItem3 = jMenu.add(new CmdOpenSVG());
        JMenuItem jMenuItem4 = jMenu.add(new CmdSave());
        JMenuItem jMenuItem5 = jMenu.add(new CmdSavePGML());
        JMenuItem jMenuItem6 = jMenu.add(new CmdSaveSVG());
        JMenuItem jMenuItem7 = jMenu.add(new CmdPrint());
        JMenuItem jMenuItem8 = jMenu.add(new CmdOpenWindow("org.tigris.gef.base.PrefsEditor", "Preferences..."));
        JMenuItem jMenuItem9 = jMenu.add(new CmdExit());
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        this._menubar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Select");
        jMenu2.add(jMenu3);
        JMenuItem jMenuItem10 = jMenu3.add(new CmdSelectAll());
        jMenu3.add(new CmdSelectNext(false));
        jMenu3.add(new CmdSelectNext(true));
        jMenu3.add(new CmdSelectInvert());
        jMenu2.addSeparator();
        JMenuItem jMenuItem11 = jMenu2.add(new CmdCopy());
        jMenuItem11.setMnemonic('C');
        JMenuItem jMenuItem12 = jMenu2.add(new CmdPaste());
        jMenuItem12.setMnemonic('P');
        JMenuItem jMenuItem13 = jMenu2.add(new CmdDelete());
        jMenu2.addSeparator();
        jMenu2.add(new CmdUseReshape());
        jMenu2.add(new CmdUseResize());
        jMenu2.add(new CmdUseRotate());
        JMenu jMenu4 = new JMenu("View");
        this._menubar.add(jMenu4);
        jMenu4.setMnemonic('V');
        jMenu4.add(new CmdSpawn());
        jMenu4.add(new CmdShowProperties());
        jMenu4.addSeparator();
        jMenu4.add(new CmdAdjustGrid());
        jMenu4.add(new CmdAdjustGuide());
        jMenu4.add(new CmdAdjustPageBreaks());
        JMenu jMenu5 = new JMenu("Arrange");
        this._menubar.add(jMenu5);
        jMenu5.setMnemonic('A');
        JMenuItem jMenuItem14 = jMenu5.add(new CmdGroup());
        jMenuItem14.setMnemonic('G');
        JMenuItem jMenuItem15 = jMenu5.add(new CmdUngroup());
        jMenuItem15.setMnemonic('U');
        JMenu jMenu6 = new JMenu("Align");
        jMenu5.add(jMenu6);
        jMenu6.add(new CmdAlign(0));
        jMenu6.add(new CmdAlign(1));
        jMenu6.add(new CmdAlign(2));
        jMenu6.add(new CmdAlign(3));
        jMenu6.add(new CmdAlign(5));
        jMenu6.add(new CmdAlign(6));
        jMenu6.add(new CmdAlign(7));
        JMenu jMenu7 = new JMenu("Distribute");
        jMenu5.add(jMenu7);
        jMenu7.add(new CmdDistribute(0));
        jMenu7.add(new CmdDistribute(1));
        jMenu7.add(new CmdDistribute(4));
        jMenu7.add(new CmdDistribute(5));
        JMenu jMenu8 = new JMenu("Reorder");
        jMenu5.add(jMenu8);
        JMenuItem jMenuItem16 = jMenu8.add(new CmdReorder(1));
        JMenuItem jMenuItem17 = jMenu8.add(new CmdReorder(2));
        JMenuItem jMenuItem18 = jMenu8.add(new CmdReorder(3));
        JMenuItem jMenuItem19 = jMenu8.add(new CmdReorder(4));
        JMenu jMenu9 = new JMenu("Nudge");
        jMenu5.add(jMenu9);
        JMenuItem jMenuItem20 = jMenu9.add(new CmdNudge(1));
        JMenuItem jMenuItem21 = jMenu9.add(new CmdNudge(2));
        JMenuItem jMenuItem22 = jMenu9.add(new CmdNudge(3));
        JMenuItem jMenuItem23 = jMenu9.add(new CmdNudge(4));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(78, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(79, 2);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(83, 2);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(80, 2);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(115, 8);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(37, 0);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(39, 0);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(37, 1);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke(39, 1);
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke(38, 1);
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke(40, 1);
        KeyStroke keyStroke14 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke15 = KeyStroke.getKeyStroke(90, 2);
        KeyStroke keyStroke16 = KeyStroke.getKeyStroke(88, 2);
        KeyStroke keyStroke17 = KeyStroke.getKeyStroke(67, 2);
        KeyStroke keyStroke18 = KeyStroke.getKeyStroke(86, 2);
        KeyStroke keyStroke19 = KeyStroke.getKeyStroke(71, 2);
        KeyStroke keyStroke20 = KeyStroke.getKeyStroke(85, 2);
        KeyStroke keyStroke21 = KeyStroke.getKeyStroke(66, 2);
        KeyStroke keyStroke22 = KeyStroke.getKeyStroke(70, 2);
        KeyStroke keyStroke23 = KeyStroke.getKeyStroke(66, 3);
        KeyStroke keyStroke24 = KeyStroke.getKeyStroke(70, 3);
        jMenuItem.setAccelerator(keyStroke2);
        jMenuItem4.setAccelerator(keyStroke3);
        jMenuItem7.setAccelerator(keyStroke4);
        jMenuItem9.setAccelerator(keyStroke5);
        jMenuItem13.setAccelerator(keyStroke14);
        jMenuItem11.setAccelerator(keyStroke17);
        jMenuItem12.setAccelerator(keyStroke18);
        jMenuItem14.setAccelerator(keyStroke19);
        jMenuItem15.setAccelerator(keyStroke20);
        jMenuItem16.setAccelerator(keyStroke23);
        jMenuItem17.setAccelerator(keyStroke24);
        jMenuItem18.setAccelerator(keyStroke21);
        jMenuItem19.setAccelerator(keyStroke22);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Globals.setStatusBar(this);
        }
    }

    public void showStatus(String string) {
        if (this._statusbar != null) {
            this._statusbar.setText(string);
        }
    }

    public JGraphFrame() {
        this("untitled");
    }

    public JGraphFrame(String string) {
        this(string, new JGraph());
    }

    public JGraphFrame(String string, Editor editor) {
        this(string, new JGraph(editor));
    }

    public JGraphFrame(String string, JGraph jGraph) {
        super(string);
        this._graph = jGraph;
        Container container = this.getContentPane();
        this.setUpMenus();
        container.setLayout(new BorderLayout());
        container.add((Component)this._menubar, "North");
        this._graphPanel.add((Component)this._graph, "Center");
        this._graphPanel.setBorder(new EtchedBorder(1));
        this._mainPanel.add((Component)this._toolbar, "North");
        this._mainPanel.add((Component)this._graphPanel, "Center");
        container.add((Component)this._mainPanel, "Center");
        container.add((Component)this._statusbar, "South");
        ((Component)this).setSize(300, 250);
        this._graph.addModeChangeListener(this);
    }

    public JGraphFrame(GraphModel graphModel) {
        this("untitled");
        this.setGraphModel(graphModel);
    }
}

