/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

public class ModeManager
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    private Vector _modes = new Vector();
    public Editor _editor;
    protected EventListenerList _listeners = new EventListenerList();
    private static /* synthetic */ Class class$Lorg$tigris$gef$event$ModeChangeListener;

    public void setEditor(Editor editor) {
        this._editor = editor;
    }

    public Editor getEditor() {
        return this._editor;
    }

    public Vector getModes() {
        return this._modes;
    }

    public void setModes(Vector vector) {
        this._modes = vector;
    }

    public Mode top() {
        if (this._modes.isEmpty()) {
            return null;
        }
        return (Mode)this._modes.lastElement();
    }

    public void push(Mode mode) {
        if (!this.includes(mode.getClass())) {
            this._modes.addElement(mode);
        }
    }

    public Mode pop() {
        if (this._modes.isEmpty()) {
            return null;
        }
        Mode mode = this.top();
        if (mode.canExit()) {
            this._modes.removeElement(mode);
            this.fireModeChanged();
        }
        return mode;
    }

    public void popAll() {
        while (!this._modes.isEmpty() && this.top().canExit()) {
            this._modes.removeElement(this.top());
        }
    }

    public boolean includes(Class clazz) {
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            if (mode.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.checkModeTransitions(keyEvent);
        int n = this._modes.size() - 1;
        while (n >= 0 && !keyEvent.isConsumed()) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.keyTyped(keyEvent);
            --n;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this._modes.size() - 1;
        while (n >= 0 && !keyEvent.isConsumed()) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.keyPressed(keyEvent);
            --n;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this._modes.size() - 1;
        while (n >= 0) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseMoved(mouseEvent);
            --n;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this._modes.size() - 1;
        while (n >= 0) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseDragged(mouseEvent);
            --n;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        int n = this._modes.size() - 1;
        while (n >= 0 && !mouseEvent.isConsumed()) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseClicked(mouseEvent);
            --n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        int n = this._modes.size() - 1;
        while (n >= 0) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mousePressed(mouseEvent);
            --n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        int n = this._modes.size() - 1;
        while (n >= 0) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseReleased(mouseEvent);
            --n;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        int n = this._modes.size() - 1;
        while (n >= 0 && !mouseEvent.isConsumed()) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseEntered(mouseEvent);
            --n;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n = this._modes.size() - 1;
        while (n >= 0 && !mouseEvent.isConsumed()) {
            Mode mode = (Mode)this._modes.elementAt(n);
            mode.mouseExited(mouseEvent);
            --n;
        }
    }

    public void checkModeTransitions(InputEvent inputEvent) {
        Object object;
        int n;
        MouseEvent mouseEvent;
        int n2;
        Fig fig;
        if (!this.top().canExit() && inputEvent.getID() == 501 && (fig = this._editor.hit(n2 = (mouseEvent = (MouseEvent)inputEvent).getX(), n = mouseEvent.getY())) instanceof FigNode && (object = ((FigNode)fig).hitPort(n2, n)) != null) {
            ModeCreateEdge modeCreateEdge = new ModeCreateEdge(this._editor);
            this.push(modeCreateEdge);
            ((Mode)modeCreateEdge).mousePressed(mouseEvent);
        }
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this._listeners.add(class$Lorg$tigris$gef$event$ModeChangeListener != null ? class$Lorg$tigris$gef$event$ModeChangeListener : (class$Lorg$tigris$gef$event$ModeChangeListener = ModeManager.class$("org.tigris.gef.event.ModeChangeListener")), modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this._listeners.remove(class$Lorg$tigris$gef$event$ModeChangeListener != null ? class$Lorg$tigris$gef$event$ModeChangeListener : (class$Lorg$tigris$gef$event$ModeChangeListener = ModeManager.class$("org.tigris.gef.event.ModeChangeListener")), modeChangeListener);
    }

    protected void fireModeChanged() {
        Object[] objectArray = this._listeners.getListenerList();
        ModeChangeEvent modeChangeEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Lorg$tigris$gef$event$ModeChangeListener != null ? class$Lorg$tigris$gef$event$ModeChangeListener : ModeManager.class$("org.tigris.gef.event.ModeChangeListener"))) {
                if (modeChangeEvent == null) {
                    modeChangeEvent = new ModeChangeEvent(this._editor, this.getModes());
                }
                ((ModeChangeListener)objectArray[n + 1]).modeChange(modeChangeEvent);
            }
            n -= 2;
        }
    }

    public void paint(Graphics graphics) {
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            mode.paint(graphics);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ModeManager(Editor editor) {
        this._editor = editor;
    }
}

