/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphEdgeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphNodeRenderer;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class LayerPerspective
extends LayerDiagram
implements GraphListener {
    public static final int GAP = 16;
    protected GraphModel _gm;
    protected GraphNodeRenderer _nodeRenderer = new DefaultGraphNodeRenderer();
    protected GraphEdgeRenderer _edgeRenderer = new DefaultGraphEdgeRenderer();
    protected Vector _allowedNetClasses = new Vector();
    protected Hashtable _nodeTypeRegions = new Hashtable();

    public GraphModel getGraphModel() {
        return this._gm;
    }

    public void setGraphModel(GraphModel graphModel) {
        this._gm.removeGraphEventListener(this);
        this._gm = graphModel;
        this._gm.addGraphEventListener(this);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._nodeRenderer;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this._nodeRenderer = graphNodeRenderer;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._edgeRenderer;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this._edgeRenderer = graphEdgeRenderer;
    }

    public void allowNetClass(Class clazz) {
        this._allowedNetClasses.addElement(clazz);
    }

    public void addNodeTypeRegion(Class clazz, Rectangle rectangle) {
        this._nodeTypeRegions.put(clazz, rectangle);
    }

    public void putInPosition(Fig fig) {
        Class<?> clazz = fig.getOwner().getClass();
        Rectangle rectangle = (Rectangle)this._nodeTypeRegions.get(clazz);
        if (rectangle != null) {
            fig.setLocation(rectangle.x, rectangle.y);
            this.bumpOffOtherNodesIn(fig, rectangle, false, true);
        }
    }

    public void bumpOffOtherNodesIn(Fig fig, Rectangle rectangle, boolean bl, boolean bl2) {
        Rectangle rectangle2 = fig.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (rectangle.intersects(rectangle2)) {
            Enumeration enumeration = this.nodesIn(rectangle2);
            if (!enumeration.hasMoreElements()) {
                return;
            }
            int n6 = (n5 + 1) / 2 * (n5 % 2 == 0 ? -1 : 1);
            if (bl2) {
                rectangle2.y = n2 + n6 * (rectangle2.height + 16);
            } else {
                rectangle2.x = n + n6 * (rectangle2.width + 16);
            }
            fig.setLocation(rectangle2.x, rectangle2.y);
            if (!rectangle.intersects(rectangle2)) {
                int n7 = rectangle.x;
                int n8 = rectangle.y;
                if (bl2) {
                    ++n3;
                    n7 = rectangle2.x + rectangle2.width + 16;
                    if (bl) {
                        n8 += n3 % 2 * (rectangle2.height + 16) / 2;
                    }
                } else {
                    ++n4;
                    n8 = rectangle2.y + rectangle2.height + 16;
                    if (bl) {
                        n7 += n4 % 2 * (rectangle2.width + 16) / 2;
                    }
                }
                fig.setLocation(n7, n8);
                rectangle2.setLocation(n7, n8);
            }
            ++n5;
        }
    }

    public void nodeAdded(GraphEvent graphEvent) {
        Object object = graphEvent.getArg();
        Fig fig = this.presentationFor(object);
        if (fig == null) {
            if (!this.shouldShow(object)) {
                System.out.println("node rejected");
                return;
            }
            FigNode figNode = this._nodeRenderer.getFigNodeFor(this._gm, this, object);
            if (figNode != null) {
                figNode.setLayer(this);
                this.putInPosition(figNode);
                this.add(figNode);
            }
        }
    }

    public void edgeAdded(GraphEvent graphEvent) {
        Object object = graphEvent.getArg();
        Fig fig = this.presentationFor(object);
        if (fig == null) {
            if (!this.shouldShow(object)) {
                System.out.println("edge rejected");
                return;
            }
            FigEdge figEdge = this._edgeRenderer.getFigEdgeFor(this._gm, this, object);
            if (figEdge != null) {
                figEdge.setLayer(this);
                this.add(figEdge);
                figEdge.computeRoute();
                figEdge.endTrans();
            }
        }
    }

    public void nodeRemoved(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    public void graphChanged(GraphEvent graphEvent) {
    }

    public boolean shouldShow(Object object) {
        if (this._allowedNetClasses.size() > 0 && !this._allowedNetClasses.contains(object.getClass())) {
            return false;
        }
        return !(object instanceof NetEdge) || this.getPortFig(((NetEdge)object).getSourcePort()) != null && this.getPortFig(((NetEdge)object).getDestPort()) != null;
    }

    public LayerPerspective(String string, GraphModel graphModel) {
        super(string);
        this._gm = graphModel;
        this._gm.addGraphEventListener(this);
    }
}

