/*
 * Decompiled with CFR 0.152.
 */
package bibTEP;

import bibTEP.Alphas;
import bibTEP.Ede;
import bibTEP.Modeles;
import bibTEP.OutputPv;
import bibTEP.ResultatCardan;
import bibTEP.SolutionR;

public class EquilibreCorpPurGeneralise {
    public static void main(String[] args) {
        double Tc = 304.128;
        double Pc = 7377300.0;
        double Zc = 0.274;
        double omega = 0.22394;
        double R = 8.314472471;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double T = 260.0;
        double deltaT = 1.0;
        int nbmodele = 3;
        int nbalpha = 8;
        Modeles mod = EquilibreCorpPurGeneralise.modeleUtilise(nbmodele, omega, Tc, Pc, Zc, R);
        SolutionR solR = EquilibreCorpPurGeneralise.r1r2(mod.u, mod.w);
        double epsilon = 1.0E-12;
        double b = mod.omegab * R * Tc / Pc;
        System.out.print("Temperature \tPression \tvL \tvV \t");
        System.out.println(" ");
        while (T <= Tc) {
            double Tr = T / Tc;
            double ac = mod.omegaa * Math.pow(R, 2.0) * Math.pow(Tc, 2.0) / Pc;
            Alphas fonctionalphas = EquilibreCorpPurGeneralise.alphaUtilise(nbalpha, omega, Tr, c1, c2, c3);
            double alpha = fonctionalphas.alpha;
            double a = ac * alpha;
            double INT = 5.92714 - 6.09648 / Tr - 1.28862 * Math.log(Tr) + 0.169347 * Math.pow(Tr, 6.0) + omega * (15.2518 - 15.6875 / Tr - 13.4721 * Math.log(Tr) + 0.43577 * Math.pow(Tr, 6.0));
            double P = Math.exp(INT) * Pc;
            OutputPv condEqui = EquilibreCorpPurGeneralise.Tfixe(P, T, mod.u, mod.w, solR.r1, solR.r2, epsilon, a, b, R);
            System.out.print(String.valueOf(T) + "\t");
            System.out.print(String.valueOf(condEqui.P) + "\t");
            System.out.print(String.valueOf(condEqui.vL) + "\t");
            System.out.print(String.valueOf(condEqui.vV) + "\t");
            System.out.println(" ");
            T += deltaT;
        }
    }

    public static ResultatCardan cubique(double a, double b, double c, double d) {
        ResultatCardan resultat = new ResultatCardan();
        double p = c / a - Math.pow(b, 2.0) / (3.0 * Math.pow(a, 2.0));
        double q = 2.0 * Math.pow(b, 3.0) / (27.0 * Math.pow(a, 3.0)) - b * c / (3.0 * Math.pow(a, 2.0)) + d / a;
        double gDelta = 4.0 * Math.pow(p, 3.0) + 27.0 * Math.pow(q, 2.0);
        double m = -q / 2.0 + 0.5 * Math.sqrt(gDelta / 27.0);
        double n = -q / 2.0 - 0.5 * Math.sqrt(gDelta / 27.0);
        double u = Math.pow(Math.abs(m), 0.3333333333333333);
        double v = Math.pow(Math.abs(n), 0.3333333333333333);
        if (gDelta > 0.0) {
            if (m < 0.0) {
                u = -u;
            }
            if (n < 0.0) {
                v = -v;
            }
            double x = u + v;
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = 0.0;
            return resultat;
        }
        if (gDelta == 0.0) {
            if (b == 0.0 & c == 0.0 && d == 0.0) {
                resultat.ZL = 0.0;
                resultat.ZI = 0.0;
                resultat.ZV = 0.0;
                return resultat;
            }
            double x = 3.0 * q / p;
            double y = -3.0 * q / (2.0 * p);
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = y += -b / (3.0 * a);
            return resultat;
        }
        double k = 3.0 * q / (2.0 * p * Math.sqrt(-p / 3.0));
        double theta = Math.acos(k);
        double x = 2.0 * Math.sqrt(-p / 3.0) * Math.cos(theta / 3.0);
        double y = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 2) / 3.0);
        double z = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 4) / 3.0);
        resultat.ZV = x += -b / (3.0 * a);
        resultat.ZI = z += -b / (3.0 * a);
        resultat.ZL = y += -b / (3.0 * a);
        return resultat;
    }

    public static Ede equationdEtat(double P, double T, double u, double w, double a, double b, double R) {
        Ede equation = new Ede();
        equation.A = P * Math.pow(R * T / P, 3.0);
        equation.B = (P * b * u - b * P - R * T) * Math.pow(R * T / P, 2.0);
        equation.C = (b * b * w * P - P * (b * b * u) - R * T * b * u + a) * (R * T) / P;
        equation.D = -b * b * b * P * w - R * T * b * b * w - a * b;
        return equation;
    }

    public static double calculFugacite(double P, double T, double r1, double r2, double a, double b, double Z, double R) {
        double v = Z * R * T / P;
        double lnphi = Z - 1.0 - Math.log(P * (v - b) / (R * T)) + a / (b * R * T * (r1 - r2)) * Math.log((v - b * r1) / (v - b * r2));
        double phi = Math.exp(lnphi);
        return phi;
    }

    public static OutputPv Tfixe(double P, double T, double u, double w, double r1, double r2, double epsilon, double a, double b, double R) {
        OutputPv CondEqui = new OutputPv();
        int compteur = 0;
        double PSave = 0.0;
        double vLSave = 0.0;
        double vVSave = 0.0;
        double vISave = 0.0;
        double critereSave = 1.0;
        double critere = 1.0;
        while (critere > epsilon && compteur < 1000) {
            Ede modele = EquilibreCorpPurGeneralise.equationdEtat(P, T, u, w, a, b, R);
            ResultatCardan Z = EquilibreCorpPurGeneralise.cubique(modele.A, modele.B, modele.C, modele.D);
            double vV = Z.ZV * R * T / P;
            double vL = Z.ZL * R * T / P;
            double vI = Z.ZI * R * T / P;
            double fugaciteL = EquilibreCorpPurGeneralise.calculFugacite(P, T, r1, r2, a, b, Z.ZL, R);
            double fugaciteV = EquilibreCorpPurGeneralise.calculFugacite(P, T, r1, r2, a, b, Z.ZV, R);
            critere = Math.abs(fugaciteL / fugaciteV - 1.0);
            PSave = P;
            vLSave = vL;
            vVSave = vV;
            vISave = vI;
            critereSave = critere;
            P *= fugaciteL / fugaciteV;
            ++compteur;
        }
        CondEqui.P = PSave;
        CondEqui.vL = vLSave;
        CondEqui.vV = vVSave;
        CondEqui.critere = critereSave;
        CondEqui.vI = vISave;
        return CondEqui;
    }

    public static SolutionR r1r2(double u, double w) {
        SolutionR solR = new SolutionR();
        solR.r1 = (-u + Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        solR.r2 = (-u - Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        return solR;
    }

    public static Modeles modeleUtilise(int n, double omega, double Tc, double Pc, double Zc, double R) {
        Modeles mod = new Modeles();
        switch (n) {
            case 0: {
                mod.u = 0.0;
                mod.w = 0.0;
                mod.omegaa = 0.421875;
                mod.omegab = 0.125;
                break;
            }
            case 1: {
                mod.u = 1.0;
                mod.w = 0.0;
                mod.omegaa = 0.42748;
                mod.omegab = 0.08664;
                break;
            }
            case 2: {
                mod.u = 2.0;
                mod.w = -1.0;
                double truc = 0.3333333333333333 * (-1.0 + Math.pow(6.0 * Math.sqrt(2.0) + 8.0, 0.3333333333333333) - Math.pow(6.0 * Math.sqrt(2.0) - 8.0, 0.3333333333333333));
                mod.omegaa = 8.0 * (5.0 * truc + 1.0) / (49.0 - 37.0 * truc);
                mod.omegab = truc / (truc + 3.0);
                break;
            }
            case 3: {
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = EquilibreCorpPurGeneralise.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = 1.0 - 3.0 * Zc;
                double b2 = mod.omegab * R * Tc / Pc;
                double c2 = mod.omegac * R * Tc / Pc;
                mod.u = 1.0 + c2 / b2;
                mod.w = -c2 / b2;
                break;
            }
            case 4: {
                double c2;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = EquilibreCorpPurGeneralise.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = (1.0 - 3.0 * Zc + mod.omegab) / mod.omegab;
                double b2 = mod.omegab * R * Tc / Pc;
                mod.u = c2 = mod.omegac * R * Tc / Pc;
                mod.w = -c2 + 1.0;
                break;
            }
            case 5: {
                double Zcc = 0.3333333333333333;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zcc + 1.0;
                double c1 = 3.0 * Zcc * Zcc;
                double d1 = -Math.pow(Zcc, 3.0);
                ResultatCardan omegaB = EquilibreCorpPurGeneralise.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZL;
                mod.omegaa = 1.0 - 3.0 * Zcc * (1.0 - Zcc) + 3.0 * (1.0 - 2.0 * Zcc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.u = 1.0;
                mod.w = 0.0;
            }
        }
        return mod;
    }

    public static Alphas alphaUtilise(int n, double omega, double Tr, double c1, double c2, double c3) {
        Alphas fonctionalpha = new Alphas();
        switch (n) {
            case 0: {
                fonctionalpha.m = 0.48 + 1.574 * omega - 0.175 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 1: {
                fonctionalpha.m = 0.4783 + 1.6337 * omega - 0.317 * Math.pow(omega, 2.0) + 0.76 * Math.pow(omega, 3.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 2: {
                fonctionalpha.m = 0.37464 + 1.54226 * omega - 0.26992 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 3: {
                if (omega < 0.4) {
                    fonctionalpha.m = 0.418 + 1.58 * omega - 0.58 * Math.pow(omega, 2.0);
                    fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                    break;
                }
                fonctionalpha.m = 0.212 + 2.2 * omega - 0.831 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 4: {
                if (Tr <= 1.0) {
                    double L0 = 0.125283;
                    double M0 = 0.911807;
                    double N0 = 1.948153;
                    double L1 = 0.511614;
                    double M1 = 0.784054;
                    double N1 = 2.812522;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.401219;
                double M0 = 4.963075;
                double N0 = -2.0;
                double L1 = 0.024955;
                double M1 = 1.248088;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 5: {
                if (Tr <= 1.0) {
                    double L0 = 0.141599;
                    double M0 = 0.919422;
                    double N0 = 2.496441;
                    double L1 = 0.500315;
                    double M1 = 0.799457;
                    double N1 = 3.29179;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.441411;
                double M0 = 6.500018;
                double N0 = -2.0;
                double L1 = 0.03258;
                double M1 = 1.289098;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 6: {
                double c0 = 0.378893 + 1.4897153 * omega - 0.17131848 * omega * omega + 0.0196554 * Math.pow(omega, 3.0);
                fonctionalpha.m = c0 + c1 * (1.0 + Math.pow(Tr, 0.5) * (0.7 - Tr));
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
            }
            case 7: {
                fonctionalpha.alpha = Tr <= 1.0 ? Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)) + c2 * Math.pow(1.0 - Math.pow(Tr, 0.5), 2.0) + c3 * Math.pow(1.0 - Math.pow(Tr, 0.5), 3.0), 2.0) : Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)), 2.0);
            }
            case 8: {
                fonctionalpha.m = 0.452413 + 1.30982 * omega - 0.296937 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
            }
        }
        return fonctionalpha;
    }
}

